//wrench material


#include "default_materials.inc"

// -----------------------------------------------------------------------------------------
//                      C O L O R S
//------------------------------------------------------------------------------------------ 

#declare C_clear  =         rgbt 1 ;
#declare C_white =          color rgb <1,1,1>  ;
#declare C_black =          color rgb <0,0,0>  ;
#declare C_gray_dark =      color rgb <0.07,0.07,0.07> ;
#declare C_gray_black =     color rgb <0.03,0.03,0.03>  ;
#declare C_red =            color rgb <1,0,0>  ;  
#declare C_red_dark =       color rgb <.5,0,0>  ; 
#declare C_maroon =         color rgb <.45,.02,.02>  ;
#declare C_green =          color rgb <0,1,0>  ;  
#declare C_yellow =         color rgb <1,.9,0>  ;
#declare C_blue =           color rgb <0,.5,.9>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_gray5 =          color red 0.05 green 0.05 blue 0.05;
#declare C_gray10 =         color red 0.1 green 0.1 blue 0.1;   
#declare C_gray20 =         color red 0.2 green 0.2 blue 0.2;
#declare C_gray30 =         color red 0.3 green 0.3 blue 0.3; 
#declare C_gray40 =         color red 0.4 green 0.4 blue 0.4;
#declare C_gray50 =         color red 0.5 green 0.5 blue 0.5;
#declare C_gray60 =         color red 0.6 green 0.6 blue 0.6; 
#declare C_gray70 =         color red 0.7 green 0.7 blue 0.7;   
#declare C_gray80 =         color red 0.8 green 0.8 blue 0.8; 
#declare C_gray90 =         color red 0.9 green 0.9 blue 0.9;
#declare C_rust_red =       color rgb <0.6, 0.3, 0.25> ;
#declare C_rust_red_film =  color rgbt <0.6, 0.3, 0.25,.5> ;
#declare C_rust_gray_film = color rgbt <0.5, 0.5, 0.5,.5> ;
#declare C_rust_gray =      color rgb <0.80, 0.80, 0.85> ;
#declare C_rust_gray_dark = color rgb <0.70, 0.70, 0.80>  ; 
#declare C_galvanize1 =     color rgb <0.90, 0.90, 0.95> ;
#declare C_galvanize2 =     color rgb <0.80, 0.80, 0.85>  ;
#declare C_breaker_black =  color rgb <0.15,.15,.17> *.3 ;
#declare C_panel_gray =     color rgb <0.15,.15,.17> * 2 ;
#declare C_gray_blue =      color red 0.8 green 0.8 blue 0.9 ;
#declare C_tan =            color red 0.85 green 0.66 blue 0.5;
#declare C_tan_dark =       color red 0.66 green 0.5 blue 0.4;
#declare C_orange =         color rgb <1,1,0>  ;
#declare C_copper =         color rgb <0.40, 0.20, 0.15>;  
#declare C_silver =         color rgb <0.85, 0.85, 0.8>;   
#declare C_gold =           color red 0.82 green 0.6 blue 0.196078;
#declare C_gold_bright=     color rgb <0.90, 0.65, 0.15>;
#declare C_light_blue =     color red 0.6 green 0.8 blue 1; 
#declare C_horizon_blue =   color red .82 green 1 blue .98; 
#declare C_blue_charcoal =  color rgb <.07,.09,.18> ;
#declare C_yellow_dull  =   color rgb <1,.9,.10>  ;
#declare C_sea_green =      color rgb <.4,1,.6> ;
#declare f = .0039  ;                             
#declare tR = 107*f ;
#declare tG = 176*f ;
#declare tB = 189*f ;
#declare C_teal = color rgb<tR,tG,tB> ;
#declare C_red50 = rgbf<1,0,0,.5>;

// -----------------------------------------------------------------------------------------
//                      S T E E L
//------------------------------------------------------------------------------------------


        
#declare C_map_steel_gray = 
color_map {
    [0.0        C_rust_gray* .73]
    [0.1        C_rust_gray * 1]
    [0.3        C_rust_gray * 1] 
    [0.55       C_rust_gray * .75]
    [0.85       C_rust_gray * .73]
    [0.9        C_rust_gray * 1]
    [1.000      C_rust_gray * .75]
}



#declare C_map_rust_overlay = 
color_map {
    [0.0        C_clear ]
    [0.2        C_rust_red ]
    [0.3        C_rust_red_film * .7] 
    [0.4        C_clear * 1]
    [0.85       C_clear * 1.5]
    [0.9        C_rust_red_film * .6]
    [1.000      C_clear]
}

#declare C_map_dirt_overlay = 
color_map {
    [0.0        C_black ]
    [0.2        C_black ]
    [0.3        C_clear ] 
    [0.5        C_rust_gray_film ]
    [0.85       C_clear ]
    [0.9        C_clear]
    [1.000      C_black]
}



#declare C_map_rust_normal = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.3        C_gray70 ] 
    [0.4        C_white ]
    [0.85       C_white ]
    [0.9        C_gray50 ]
    [1.000      C_white ]
}

    
#declare C_map_dent_A = 
color_map {
    [0.0        C_white ]
    [0.2        C_gray50 ]
    [0.3        C_black ] 
    [0.4        C_black ]     
    [0.5        C_white ]
    [0.85       C_white ]
    [0.9        C_gray50 ]
    [1.000      C_white ]
}

#declare F_old_steel  =
finish {  
    reflection {.001, .6 fresnel on } 
    conserve_energy 
    brilliance 5
    ambient 0
    diffuse .8 
    metallic
    specular 3 
    roughness .1
    reflection .25 
}

//--- steel old
#declare sz = <.6,2,.6> ;   
#declare turb = 1.1; 
#declare bump = .03; 

#declare T_steel_old =
texture { 
    pigment { 
        spotted 
        color_map {C_map_dirt_overlay} 
        turbulence turb
        scale sz
        } 

    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     }   
 }


//--- steel noise
#declare sz = <.2,.2,.2> ;   
#declare turb = 1.1; 
#declare bump = .3; 
#declare T_steel_noise =
texture { 
    pigment { 
        spotted 
        color_map {C_map_dirt_overlay} 
        turbulence turb
        scale sz
        } 
    normal {
         crackle 
         turbulence turb 
         bump_size bump
         scale sz
     } 
     finish{F_old_steel}  
 }  
 

//--- steel old spotted
#declare sz = <.83,.83,.83> ;   
#declare turb = .03; 
#declare bump = .02; 

#declare T_steel_spotted =
texture { 
    pigment { 
        spotted 
        color_map {C_map_steel_gray} 
        turbulence turb
        scale sz
        } 

    finish{F_old_steel}
    

 }


#declare M_wrech_smooth =
material {
   texture { T_steel_spotted    rotate <30,30,30> scale <3,2,3>}
   texture { T_steel_old scale <1,1,1> }
}



#declare M_wrech_noise =
material {
    texture { T_steel_noise }
}    


#declare imgDiffuse = "wrench/wrench_grip_diffuse.png"   
#declare imgBump = "wrench/wrench_grip_diffuse.png"
#declare M_wrench_grip =
material {
    texture {
       pigment { 
            image_map {
                png imgDiffuse     
                map_type 0
                interpolate 4 
                }
      }
     normal  {
        bump_map {
            png imgBump 
            map_type 0
            interpolate 4 
        } 
        bump_size .5
    }
    finish {F_dull}
    }
    scale <30,75,1> 
    translate <-15,0,0>  
}


//---default materials
//#declare M_wrech_smooth = material {M_red_gloss} ;
//#declare M_wrech_noise  = material {M_blue_gloss}  ;